/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2006 Phex Development Group
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: InternalFileHandler.java 3859 2007-07-01 20:15:19Z gregork $
 */
package phex.utils;

import java.io.*;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.httpclient.URI;

import phex.download.swarming.SwarmingManager;
import phex.share.FileRescanRunner;

import phex.metalink.*;

/**
 * Offers internal handling for files like magma-lists, rss-feeds, podcasts and similar. 
 */
public final class InternalFileHandler
{
    public static void magmaReadout( File file )
    {
    	try
        {
            BufferedInputStream inStream = new BufferedInputStream( new FileInputStream( file ) );
            MagmaParser parser = new MagmaParser( inStream );
            parser.start();

            List magnetList = parser.getMagnets();
            Iterator iter = magnetList.iterator();
        
            // Sync subscription operation with a possible rescan process, this 
            // prevents downloads of files already existing but not yet scanned.
            FileRescanRunner.sync();

            while (iter.hasNext())
            {
                String magnet = (String) iter.next();
                URI uri = new URI( magnet, true );

                // dont add already downloading or shared urns.
                downloadUri( uri );
            }
/*            String uuri = parser.getUpdateURI(); 
            if ( uuri != null) 
            { 
            	URI uri = new URI( uuri, true ); 
            	sheduledReadout(uri, 60000); 
            }
            
            */
        
        }
        catch (IOException exp)
        {
            NLogger.warn(NLoggerNames.MAGMA, exp.getMessage(), exp);
        }
    }
    public static void rssReadout( File file )
    {
            if (!file.exists())
        {
            return;
        }
        try
        {
            Reader reader = new BufferedReader(new FileReader(file));
            RSSParser parser = new RSSParser(reader);
            parser.start();

            List magnetList = parser.getMagnets();
            Iterator iter = magnetList.iterator();
        
            // Sync subscription operation with a possible rescan process, this 
            // prevents downloads of files already existing but not yet scanned.
            FileRescanRunner.sync();

            while (iter.hasNext())
            {
                String magnet = (String) iter.next();
                URI uri = new URI( magnet, true );
                downloadUri( uri );
            }

        }
        catch (IOException exp)
        {
            NLogger.error(NLoggerNames.RSS, exp.getMessage(), exp);
        }
    }
    
    public static void metalinkReadout( File file )
    {
            if (!file.exists())
        {
            return;
        }
        try
        {
            BufferedInputStream inStream = new BufferedInputStream( new FileInputStream( file ) );
            MetalinkUtils parser = new MetalinkUtils(inStream);
            parser.start();

            List magnetList = parser.getMagnets();
            Iterator iter = magnetList.iterator();
        
            // Sync subscription operation with a possible rescan process, this 
            // prevents downloads of files already existing but not yet scanned.
            FileRescanRunner.sync();

            while (iter.hasNext())
            {
                String magnet = (String) iter.next();
                URI uri = new URI( magnet, true );
                downloadUri( uri );
            }

        }
        catch (IOException exp)
        {
            NLogger.error(NLoggerNames.RSS, exp.getMessage(), exp);
        }
    }

    public static void sheduledReadout( URI uri, long time )
    {
        // this should download again after a certain time. 
    	downloadUri( uri );
    }

    private static void downloadUri( URI uri )
    {
        try
        {
            SwarmingManager.getInstance().addFileToDownload( uri, true );
        }
        catch (IOException exp)
        {
            NLogger.warn( InternalFileHandler.class, exp.getMessage(), exp);
        }
    }


}
